## 3e: Housing affordability declines over time
## Probability of entry into homeownership falls by 2 per cent each year for everyone but the highest income quintile. 
## Entry prices for housing increase 2 per cent faster each year. Housing returns are at historical rates.


# Prelims -----------------------------------------------------------------

gc()


# Read in base housing params ---------------------------------------------

## starting cohort pathways (from step 3)
starting_cohorts_pathways <- qread(starting_cohorts_pathways_file)


## housing "savings" AND "drawdowns" given historical housing returns
housing_asset_saving <- qread("./Input data/saving_housing_a.qs") %>% 
  select(age_grp2, housing_asset_saving_param_adj = upsize_rate_housing)



# Adjust for scenario -----------------------------------------------------

## Reduce probability of entry by 2% each year
home_transition_prob_adj <- starting_cohorts_pathways %>% 
  distinct(age_grp, year, total_inc_qtile, beqrec, home_trans_prob) %>% 
  mutate(home_trans_prob_adj = ifelse(total_inc_qtile!=5, home_trans_prob*(0.98)^(year), home_trans_prob)) %>%  ## assume top quintile rates stay the same
  arrange(total_inc_qtile, age_grp, year)

## Increase value of housing when purchased by 2% each year
new_housing_value_adj <- starting_cohorts_pathways %>% 
  distinct(year, total_inc_qtile, new_housing_val_param) %>% 
  mutate(new_housing_val_param_adj = new_housing_val_param*(1.02)^(year)) 



# Put into new version of starting_cohorts, convert to year list and save --------

starting_cohorts_pathways_adj <- starting_cohorts_pathways %>% 
  left_join(home_transition_prob_adj) %>% 
  left_join(new_housing_value_adj) %>% 
  ## replace values
  select( -home_trans_prob, home_trans_prob = home_trans_prob_adj,
          -new_housing_val_param, new_housing_val_param = new_housing_val_param_adj ) %>% 
  ## adjust housing asset returns to historical 7%
  mutate(housing_asset_return_param = 0.07) %>% 
  ## housing saving given historical rates
  left_join(housing_asset_saving) %>% 
  select(-housing_asset_saving_param, housing_asset_saving_param = housing_asset_saving_param_adj)



## split into list by year - save for use in model running
year_list_0 <- starting_cohorts_pathways_adj %>% 
  split(., .$year) 

qsave(year_list_0, "./Output data/year_list_0_declining_house_afford.qs")
